<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\Persona;

class DifusionController extends Controller
{
    public function obtenerDifusion()
    {
        //$lista = ['data' => []];
        $lista = [];
        $personas = Persona::where(function ($query) {
            $query->where('top', '=', 1)
                ->orWhere('alerta_sofia', '=', 1);
        })->orderBy('alerta_sofia', 'DESC')->orderBy('top', 'DESC')->orderBy('fecha_desaparicion', 'DESC')->get();
        foreach ($personas as $persona) {
            $lista[] = [
                //$lista ['data'][] = [
                'id' => $persona->id,
                'nombre' => $persona->nombre,
                'imagen' => asset('storage/' . $persona->imagen),
                'ubicacion' => $persona->ubicacion,
                'categoria' => $persona->categoria->descripcion,
            ];
        }
        return response()->json($lista);
    }
}
