<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\Persona;

class PersonaController extends Controller
{
    public function obtenerPersona($users_id)
    {
        $response = [];
        $persona = Persona::where('id', $users_id)->first();
        if ($persona) {
            $response[] = [
                'id' => $persona->id,
                'nombre' => $persona->nombre,
                'imagen' => asset('storage/' . $persona->imagen),
                'ubicacion' => $persona->ubicacion,
                'fecha_nacimiento' => $persona->fecha_nacimiento,
                'fecha_desaparicion' => $persona->fecha_desaparicion,
                'recompensa' => $persona->recompensa,
                'informacion' => $persona->informacion,
                'link' => $persona->link,
                'top' => $persona->top,
                'alerta_sofia' => $persona->alerta_sofia,
                'categoria' => $persona->categoria->descripcion,
            ];
        }
        return response()->json($response);
    }
}
