<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Persona extends Model
{
    use HasFactory;
    
    public $table = "personas";
    
    protected $fillable = [
        'nombre',
        'imagen',
        'ubicacion',
        'fecha_nacimiento',
        'fecha_desaparicion',
        'recompensa',
        'informacion',
        'link',
        'top',
        'alerta_sofia',
        'missing_children',
        'categoria_id',
    ];

    public function categoria(): BelongsTo
    {
        return $this->belongsTo(Categoria::class);
    }
}
