<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('personas', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('imagen');
            $table->string('ubicacion')->nullable();
            $table->date('fecha_nacimiento')->nullable();
            $table->date('fecha_desaparicion')->nullable();
            $table->string('recompensa')->nullable();
            $table->text('informacion')->nullable();
            $table->string('link')->nullable();
            $table->boolean('top')->default(0);
            $table->boolean('alerta_sofia')->default(0);
            $table->boolean('missing_children')->default(0);
            $table->foreignId('categoria_id')->constrained('categorias')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('personas');
    }
};
