<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\DifusionController as DifusionV1;
use App\Http\Controllers\Api\V1\PersonaController as PersonaV1;
use App\Http\Controllers\DispositivoController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('V1/difusiones', [DifusionV1::class, 'obtenerDifusion']);
Route::get('V1/personas/{users_id}', [PersonaV1::class, 'obtenerPersona']);
Route::post('/guardar-dispositivo', [DispositivoController::class, 'guardarDispositivo']);