<?php

namespace Filament\Tables\Columns\Concerns;

use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;

trait BelongsToTable
{
    protected ?Table $table = null;

    public function table(?Table $table): static
    {
        $this->table = $table;

        return $this;
    }

    public function getTable(): Table
    {
        return $this->table ?? $this->getLayout()->getTable();
    }

    public function getLivewire(): HasTable
    {
        return $this->getTable()->getLivewire();
    }
}
