<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Categoria extends Model
{
    use HasFactory;
    
    public $table = "categorias";
    
    protected $fillable = [
        'descripcion',
        'orden',
        'color',
    ];
    
    public function personas(): HasMany
    {
        return $this->hasMany(Persona::class);
    }
}
